class Hellfighter extends Konglauncher config(UTjetV2);


var Fuelcore fc;                              // Keeps track of fuel cores for the ret HUD.
var vector launchv;                              // Owner velocity at launch.
var float lastFired;                         // Bots should only fire every so often...
var SkyNet skynet;
var SkyNode launchsn;                         // Our onramp onto the network.
var() config bool bNeverStay;
var bool bClear;
var float clearanceStamp;
var() config string teamSLClass[4];
var UT_ShieldBeltEffect MyEffect;
var() config bool bForceLaunchPuff;
var bool bPendingLock;
var Actor LockedTarget, NewTarget, OldTarget;
var byte Teams;
var bool bUsedNXLaunch;
var() config float CustomRespawnTime;

replication {
	 reliable if (role == ROLE_Authority && bNetOwner)
		  bClear, bUsedNXLaunch;
}

function bool handlePickupQuery(Inventory i)
{
local Pawn p;
local int oldAmmo;
local int rounds;
local Inventory Inv;
local bool bHaveAlready;

	//u.debug("handlePickupQuery()");

	p = Pawn(owner);

	for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if (Inv.Class == i.Class) 
			{
			bHaveAlready = True;
			}

		}

	if ( bHaveAlready )
		return false;

	if (i.class == class && !bHaveAlready) {
		// NEVER return false past this point. You'll end up with doubles.


		if (bAkimbo && slave == none) {
			// Spawn the slave weapon.
			slave = spawn(class, p);
			itemName = slaveName;
			// FIX. Generalize.
			AIRating = 0.4;
			slave.setupSlave(self, Pawn(owner).weapon == self);
		} else {

			// Can't cheat with weapon stay...
			if (Weapon(i).bWeaponStay && (!Weapon(i).bHeldItem || Weapon(i).bTossedOut))
				return true;

			/** With clipped weapons that are dropped, you can take the clip out.
			*/
			if (ammo().bClipped && SLWeapon(i).clip != none) {
				ammo().addClip(SLWeapon(i).clip);
			} else {
				// WTF is all this?????
				if (ammoType != none) {
					oldAmmo = getAmmo();
					if (ammoType.addAmmo(Weapon(i).pickupAmmoCount) && (oldAmmo == 0) && (p.weapon.class != i.class) && !p.bNeverSwitchOnPickup) {
						weaponSet(p);
					}
				}
			}
		}

		p.receiveLocalizedMessage(class'PickupMessagePlus', 0, none, none, self.class);
		i.playSound(i.pickupSound);
		if (level.game.LocalLog != none)
			level.game.LocalLog.logPickup(i, Pawn(owner));
		if (level.game.WorldLog != none)
			level.game.WorldLog.logPickup(i, Pawn(owner));
		i.setRespawn();

		return true;

	} // Same class.

	// Continue down the chain.
	if (inventory == none)
		return false;
	if ( !bHaveAlready )
		return inventory.handlePickupQuery(i);
}


function PreBeginPlay()
{
	RespawnTime = Default.CustomRespawnTime;
	Super.PreBeginPlay();
}

simulated event RenderOverlays( canvas Canvas )
{
    local rotator NewRot;
    local bool bPlayerOwner;
    local int Hand;
    local PlayerPawn PlayerOwner;

    if ( bHideWeapon || (Owner == None) )
        return;

    PlayerOwner = PlayerPawn(Owner);

    if ( PlayerOwner != None )
    {
        if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
            return;
        bPlayerOwner = true;
        Hand = PlayerOwner.Handedness;

        if (  (Level.NetMode == NM_Client) && (Hand == 2) )
        {
            bHideWeapon = true;
            return;
        }
    }

    if ( !bPlayerOwner || (PlayerOwner.Player == None) )
        Pawn(Owner).WalkBob = vect(0,0,0);

    if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash && Level.bHighDetailMode && (MFTexture != None) )
    {
        MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
        if ( !bSetFlashTime )
        {
            bSetFlashTime = true;
            FlashTime = Level.TimeSeconds + FlashLength;
        }
        else if ( FlashTime < Level.TimeSeconds )
            bMuzzleFlash = 0;
        if ( bMuzzleFlash > 0 )
        {
            if ( Hand == 0 )
                Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
            else
                Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);

            Canvas.Style = 3;
            Canvas.DrawIcon(MFTexture, MuzzleScale);
            Canvas.Style = 1;
        }
    }
    else
        bSetFlashTime = false;

    SetLocation( Owner.Location + CalcDrawOffset() );
    NewRot = Pawn(Owner).ViewRotation;

    if ( Hand == 0 )
        newRot.Roll = -2 * Default.Rotation.Roll;
    else
        newRot.Roll = Default.Rotation.Roll * Hand;

    setRotation(newRot);
    Canvas.DrawActor(self, false,True);
}


function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
	{
		Mesh = mesh'NukeLauncher';
		PlayerViewMesh = mesh'NukeLauncher';
	}
	else
	{
		Mesh = mesh'NukeLauncherR';
		PlayerViewMesh = mesh'NukeLauncherR';
	}
}

//=============
// METHODS
//==============

/** Set the projectile classes based on team.
*/
function bringUp() {
	 
     local PlayerReplicationInfo pri;
     // Teams alternate rocket types.
     if (Pawn(owner) != none) {
       pri = Pawn(owner).playerReplicationInfo;
       projectileClass = (Class'HellSLV');

	if (pri.team == 0)
		{
		altProjectileClass = (Class'HellShell');
		}
	else if (pri.team == 1)
		{
		altProjectileClass = (Class'BlueShell');
		}
	else if (pri.team == 2)
		{
		altProjectileClass = (Class'GreenShell');
		}
	else
		{
		altProjectileClass = (Class'GoldShell');
		}
     }
     //}
     //super.bringup();
}

state Idle {

	  simulated function timer() {
	  super.timer();
	  NewTarget = CheckTarget();
          if ( NewTarget == OldTarget )
	  {
	        LockedTarget = NewTarget;
	        If (LockedTarget != None)
	        {
	             bLockedOn=True;
		     Owner.MakeNoise(Pawn(Owner).SoundDampening);
		     Owner.PlaySound(Misc1Sound, SLOT_None,Pawn(Owner).SoundDampening);
		     if ( (Pawn(LockedTarget) != None) && (FRand() < 0.7) )
			  Pawn(LockedTarget).WarnTarget(Pawn(Owner), ProjectileSpeed, vector(Pawn(Owner).ViewRotation));
		     if ( bPendingLock )
		     {
			 oldTarget = NewTarget;
		         Pawn(Owner).bFire = 0;
		         GotoState('Fire', 'Begin');
		         return;
                     }
		}
	  }

	  else if( (OldTarget != None) && (NewTarget == None) )
	  {
	       Owner.PlaySound(Misc2Sound, SLOT_None,Pawn(Owner).SoundDampening);
	       bLockedOn = False;
          }
          else
          {
	       LockedTarget = None;
	       bLockedOn = False;
          }
          OldTarget = NewTarget;
          bPendingLock = false;
     }

Begin:
     if (Pawn(Owner).bFire!=0) Fire(0.0);
     if (Pawn(Owner).bAltFire!=0) AltFire(0.0);
     bPointing=False;
     if (AmmoType.AmmoAmount<=0)
	  Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
     OldTarget = CheckTarget();
     SetTimer(0.75,True);  //1.25
     LockedTarget = None;
     bLockedOn = False;
PendingLock:
	 if ( bPendingLock )
	      bPointing = true;
	 if ( TimerRate <= 0 )
	      SetTimer(0.5, true); //1.0
}

simulated function PostRender(canvas Canvas)
{
     local float XScale;
     Super.PostRender(Canvas);
     bOwnsCrossHair = bLockedOn;
     if ( bOwnsCrossHair )
     {
          // if locked on, draw special crosshair
          XScale = FMax(1.25, Canvas.ClipX/640.0);
          Canvas.SetPos(0.525 * (Canvas.ClipX - Texture'TargetLocked'.USize * XScale), 0.525 * (Canvas.ClipY - Texture'TargetLocked'.VSize * XScale));
          Canvas.Style = ERenderStyle.STY_Translucent;
          Canvas.DrawIcon(Texture'TargetLocked', 1.25);
          Canvas.Style = 1.25;
     }
}

/** Function for bots. Returns true if they should ride a rocket. Not
	 simulated so we don't need the role check.             
*/
function bool useAltFire(Bot b) {
         local BotReplicationInfo bri;
	 local HellShell sl;//StrangeShell throughout

	 //u.debug("useAltFire(): ammo: " $ ammoLeft() $ " enemy: " $ b.enemy $ " orders: " $ b.orders);

	 bri = BotReplicationInfo(b.playerReplicationInfo);

	 // Only used in CTF and assault gametypes. And for assault, only if they're attacking.
	 if (!(level.game.isA('CTFGame') || (level.game.isA('Assault') && bri.team == Assault(level.game).attacker.teamIndex)))
		  return false;

	 if (!ammoLeft() || b.enemy != none)
		  return false;

	 // Which? FIX.
	 if (bri.realOrders == 'Defend' || bri.realOrders == 'Follow')
		  return false;

	 // Not if we're already riding one.
	 foreach b.radiusActors(Class'HellShell', sl, vsize(Class<HellShell>(projectileClass).default.pilotOffset) * 2.0) {
		  if (sl.getPilot() == b || sl.getGunner() == b)
			   return false;
	 }
	 
         return true;
}


function spawnSkyNet() {
	 foreach allActors(Class'SkyNet', skynet)
		  break;

	 // Spawn it!
	 if (skynet == none)
		  skynet = spawn(Class'SkyNet');
}

/** Needed to add fuel core count to the HUD.
*/
simulated function setRetMsgs() {
     super.setRetMsgs();

     if (!bClear && (level.timeseconds - clearanceStamp < 1.5)) {
		  retmsg = "no clearance!";
     }
     if (fc == none)
         fc = Fuelcore(Pawn(owner).findInventoryType(class'Fuelcore'));
     if (fc != none && fc.ammoAmount > 0)
          retmsg2 = "cores " $ fc.ammoAmount;
}

/** The Redeemer never stays.
*/
function setWeaponStay() {
	 if (bNeverStay)
	      bWeaponStay = false;
	 else
	      super.setWeaponStay();
}

/** Launch puffs spawned on the server.
*/
function spawnPuff() {
     local vector x, y, z;

         if (bForceLaunchPuff == true){
            getAxes(owner.rotation, x, y, z);
              spawn(class'LaunchPuff',,, owner.location + x * 80, rotation);
            } else if (level.bHighDetailMode && !level.bDropDetail && level.netmode != NM_DedicatedServer) 	 {
          // Place it in view.

          getAxes(owner.rotation, x, y, z);
          spawn(class'LaunchPuff',,, owner.location + x * 80, rotation);
     }
}

/** If we had a successful launch, spawn the puff.
*/


function fire(float v) {

     local Vector Start, X,Y,Z;
    lastFired = level.timeseconds;
 	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if (AmmoType.UseAmmo(1))
	{

        bPointing=true;
        bCanClientFire=true;
        GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
        Start = Owner.Location + CalcDrawOffset();
        Spawn(Class'WeaponLight',,'',Start+X*20,rot(0,0,0));
        Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
        AdjustedAim = pawn(owner).AdjustToss(ProjectileSpeed, Start, AimError,true,bWarnTarget);


    if ( Pawn(Owner).PlayerReplicationInfo.Team == 0 ) {
     
        Spawn(class'HellSlv',,, Start,AdjustedAim);

    } if ( Pawn(Owner).PlayerReplicationInfo.Team == 1 ) {

        Spawn(class'HellSlv',,, Start,AdjustedAim);
    }
      if ( Pawn(Owner).PlayerReplicationInfo.Team == 2 ) {

        Spawn(class'HellSlv',,, Start,AdjustedAim);
    }
      if ( Pawn(Owner).PlayerReplicationInfo.Team == 3 ) {

        Spawn(class'HellSlv',,, Start,AdjustedAim);

    }

  
//super.fire(v);

	}


	if (lastProj != none)
       spawnPuff();
    if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) )
    {
    	 Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
    }
}

function altFire(float v)
{
     local bool bAmmo;
   //  local Inventory IP;
     bAmmo = ammoLeft();

    if (bAmmo)
	{
       spawnProjOffset = -(Class<HellShell>(altProjectileClass).default.pilotOffset);
       bSetProjOwner = true;
       Pawn(Owner).bHidden = true;
       lastProj = none;
    }
    // All just to get the click...
    super.altFire(v);

    if (bAmmo)
	 {
          if (lastProj != none)
	  {
          HellShell(lastProj).setPilot(Pawn(owner)); //, skynet, launchsn);
          } 
	  else {
               clearWarning();
               clearanceStamp = level.timeseconds;
          }
          bClear = (lastProj != none);
          // Unset these. Dumbs don't need them.
          spawnProjOffset = vect(0, 0, 0);
          bSetProjOwner = false;
          Pawn(Owner).bHidden = false;

     }
}

/** Plays the clearance warning on the client. Is there a way to quiet
     this? FIX.
*/
function clearWarning() {
     if (owner.isA('PlayerPawn'))
          PlayerPawn(owner).clientPlaySound(Class'HellShell'.default.warnSound, false, true);
}

simulated function bool clientFire(float v) {
     // Reset it.
     launchv = vect(0, 0, 0);
     return super.clientFire(v);
}
simulated function bool clientAltFire(float v) {

	bUsedNXLaunch = True;

     if (super.clientAltFire(v)) {
          clearanceStamp = level.timeseconds;
          launchv = owner.velocity;
          return true;
     } else {
     return false;
     }
}

function Actor CheckTarget() {

     local Actor ETarget;
     local Vector Start, X,Y,Z;
     local float bestDist, bestAim;
     local Pawn PawnOwner;
     local rotator AimRot;
     local int diff;

     PawnOwner = Pawn(Owner);
     bPointing = false;
     if ( Owner.IsA('PlayerPawn') )
     {
          GetAxes(PawnOwner.ViewRotation,X,Y,Z);
          Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
          bestAim = 0.93;
          ETarget = PawnOwner.PickTarget(bestAim, bestDist, X, Start);
     }
     else if ( PawnOwner.Enemy == None )
          return None;
     else if ( Owner.IsA('Bot') && Bot(Owner).bNovice )
          return None;
     else if ( VSize(PawnOwner.Enemy.Location - PawnOwner.Location) < 2000 )
     {
          Start = Owner.Location + CalcDrawOffset() + FireOffset.Z * vect(0,0,1);
          AimRot = rotator(PawnOwner.Enemy.Location - Start);
          diff = abs((AimRot.Yaw & 65535) - (PawnOwner.Rotation.Yaw & 65535));
          if ( (diff > 7200) && (diff < 58335) )
               return None;
          // check if can hold lock
          if ( !bPendingLock ) //not already locked
          {
               AimRot = rotator(PawnOwner.Enemy.Location + (3 - PawnOwner.Skill) * 0.3 * PawnOwner.Enemy.Velocity - Start);
               diff = abs((AimRot.Yaw & 65535) - (PawnOwner.Rotation.Yaw & 65535));
		if ( (diff > 16000) && (diff < 49535) )
        return None;
          }

          // check line of sight
          ETarget = Trace(X,Y, PawnOwner.Enemy.Location, Start, false);
          if ( ETarget != None )
               return None;

          return PawnOwner.Enemy;
     }
     bPointing = (ETarget != None);
     Return ETarget;
}

/** From Botpack.WarheadLauncher.
*/
function float rateSelf(out int bUseAltMode) {
	local Bot me;

	// Alt-fire handled separately in the idle loop.
	bUseAltMode = 0;

	me = Bot(owner);
	if (me == none || !ammoLeft() || (level.timeseconds - lastFired) < 2.0)
		return -2.0;

	// Keep the weapon out until we're under fire. We may alt-fire to
	// get on the sky network.
	if (useAltFire(me))
		return 1.0;

	if (me.enemy == none)
		return -2.0;
	
	if (vsize(me.enemy.location - me.location) > 800 && fastTrace(me.enemy.location, me.location)) {
		u.debug("rateSelf(): enemy past det range: " $ u.sname(me.enemy));
		return 2.0;
	}

	return -1.0;
}


function float suggestAttackStyle() {
	return -1.0;
}

simulated function playSelect() {
	//u.debug("playSelect()");

	bForceFire = false;
	bForceAltFire = false;
	bCanClientFire = false;

	if (ammoLeft())
		bUsedNXLaunch = False;

/*	ThirdPersonMesh = mesh'NukeLauncherM';

	if (PlayerPawn(Owner) != None)
	{
	if ( PlayerPawn(Owner).Handedness == 1 )
	{
		Mesh = mesh'NukeLauncher';
		PlayerViewMesh = mesh'NukeLauncher';
	}
	else
	{
		Mesh = mesh'NukeLauncherR';
		PlayerViewMesh = mesh'NukeLauncherR';
	}
	}
*/
	if (!isAnimating() || (animSequence != assSelect.aname))
		playAss(assSelect);
}

simulated function tweenDown() {
local bool bAmmoC;

	//u.debug("tweenDown()");

	if (ammoType != none)
		bAmmoC = (ammoType.AmmoAmount > 0);

	if (isAnimating() && (animSequence != '') && (getAnimGroup(animSequence) == assSelect.aname))
		tweenAnim(animSequence, animFrame * 0.4);
	else if (bAmmoC || bUsedNXLaunch)
		playAss(assDown);
	else
		playAss(assFire);

/*	if (!ammoLeft())
	{

	ThirdPersonMesh = mesh'NukeLauncherMW';

	
	if (PlayerPawn(Owner) != None)
	{
	if ( PlayerPawn(Owner).Handedness == 1 )
	{
		Mesh = mesh'NukeLauncherW';
		PlayerViewMesh = mesh'NukeLauncherW';
	}
	else
	{
		Mesh = mesh'NukeLauncherRW';
		PlayerViewMesh = mesh'NukeLauncherRW';
	}
	}

	}
*/
}


function dropFrom(vector startLoc) {
	//u.debug("dropFrom()");

	if (slave == none) {
		// We don't transfer clips with dropped weapons.
		if (ammo().bClipped) {
			// This keeps the super call from setting ammo.
			ammoType = none;

			// Keep the clip. Unset pickup ammo.
			pickupAmmoCount = 0;
		}

		// Unset the master.
		master = none;

		super.dropFrom(startLoc);
	} else {
		slave.dropFrom(startLoc);
	}

	Mesh = LodMesh'JetXRed';
	//Mesh = mesh'NukeLauncherPick';
}


//  The End

defaultproperties
{
    bNeverStay=True
    CustomRespawnTime=0.00
    wallhitClass=Class'SLWallhit'
    assFire=(aname=Fire,arate=1.00,tween=0.10,Sound=Sound'NukeLauncher.NukeFire',Volume=20.00,Slot=0,bSkipOwner=True),
    assAltFire=(aname=AltFire,arate=0.00,tween=0.00,Sound=Sound'NukeLauncher.XNXAlt',Volume=3.00,Slot=0,bSkipOwner=True),
    assSelect=(aname=Select,arate=1.00,tween=0.00,Sound=Sound'NukeLauncher.NukeSelect',Volume=1.00,Slot=1,bSkipOwner=False),
    assReload=(aname=Reload,arate=0.20,tween=0.00,Sound=Sound'SLV2Sounds.Weapon.Reload',Volume=1.00,Slot=1,bSkipOwner=False),
    assIdle=(aname=Idle,arate=0.90,tween=0.00,Sound=None,Volume=1.00,Slot=1,bSkipOwner=True),
    paSlide=0.75
    mimicPriorityOf=WarheadLauncher
    WeaponDescription="Giant, yet portable anti-everything rocket."
    InstFlash=-0.40
    InstFog=(X=950.00,Y=650.00,Z=290.00),
    AmmoName=Class'StrangeAmmo'
    ReloadCount=1
    bWarnTarget=True
    bAltWarnTarget=True
    bSplashDamage=True
    ProjectileClass=Class'HellSlv'
    AltProjectileClass=Class'HellShell'
    MyDamageType=StrangeDeath
    shakemag=350.00
    shaketime=0.20
    shakevert=7.50
    AIRating=1.00
    RefireRate=0.25
    AltRefireRate=0.25
    FireSound=Sound'NemesisWINGSvXc.NukeLauncher.NukeFire'
    SelectSound=Sound'NemesisWINGSvXc.NukeLauncher.NukeSelect'
    DeathMessage="%o was nuked By %k's %w."
    NameColor=(R=10,G=0,B=0,A=0),
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got the UT Hellfighter "
    ItemName="UT Hellfighter"
    //PlayerViewOffset=(X=30.00,Y=-20.00,Z=-12.00)
    PlayerViewOffset=(X=1.800,Y=1.00,Z=-1.8900)
    PlayerViewMesh=LodMesh'JetXRed'
    PlayerViewScale=1
    BobDamping=0.98
    PickupViewMesh=LodMesh'JetXRed'
    //ThirdPersonMesh=LodMesh'Botpack.WHHand'
    ThirdPersonMesh=LodMesh'JetXRed'
    ThirdPersonScale=0.85
    StatusIcon=Texture'Icons.NukeIconWings'
    MaxDesireability=0.00
    PickupSound=Sound'NemesisWINGSvXc.NukeLauncher.NukePick'
    Icon=Texture'Icons.NukeIconWings'
    Physics=0
    LODBias=3.00
    Rotation=(Pitch=0,Yaw=0,Roll=-500),
    Texture=Texture'Skins.MetalShineBlood'
    Mesh=LodMesh'JetXRed'
    AmbientGlow=125
    bUnlit=True
    CollisionRadius=45.00
    CollisionHeight=23.00
    MultiSkins(1)=FireTexture'UnrealShare.Effect3.fireeffect3a'
    MultiSkins(2)=FireTexture'UnrealShare.Effect3.fireeffect3a'
    MultiSkins(3)=FireTexture'UnrealShare.Effect3.fireeffect3a'
    MultiSkins(4)=FireTexture'UnrealShare.Effect3.fireeffect3a'
}
